<?php
// Nama file bin yang mau dibaca
$binFile = 'talents.bin';

$data = file_get_contents($binFile);
if ($data === false) {
    die("Gagal baca $binFile\n");
}

// Coba decompress sebagai zlib (sesuai Zlib.decompress di AS3)
$json = @gzuncompress($data);
if ($json === false) {
    // Kalau gagal, coba raw deflate (jaga-jaga)
    $json = @gzinflate($data);
}

if ($json === false) {
    die("Gagal decompress (bukan zlib/deflate yang valid)\n");
}

// Optional: validasi JSON & pretty-print
$obj = json_decode($json);
if ($obj === null) {
    // Bukan JSON valid, tapi tetap tulis teks mentah
    file_put_contents('enemy_raw.txt', $json);
    echo "Decompress OK, tapi JSON invalid. Lihat enemy_raw.txt\n";
    exit;
}

$pretty = json_encode($obj, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
file_put_contents('talents.json', $pretty);

echo "OK, hasil disimpan ke enemy.json\n";